package org.retentionprediction;

import javax.swing.JPanel;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

import java.awt.Rectangle;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.awt.Dimension;
import java.lang.String;

public class PreloadedValuesDialog extends JDialog implements ActionListener
{
	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JComboBox jcboInstrument = null;
	private JButton jbtnOk = null;
	private JButton jbtnCancel = null;
	private JPanel jPanel = null;
	
	public boolean m_bOk = false;
	private JLabel jLabel = null;
	private JLabel jLabel1 = null;
	private JComboBox jcboGradientFlowRate = null;
	public int m_iInstrument = 0;
	public int m_iCondition = 0;
	
	/**
	 * @param owner
	 */
	public PreloadedValuesDialog(Frame owner) 
	{
		super(owner);
		initialize();
		
		jbtnOk.addActionListener(this);
		jbtnCancel.addActionListener(this);
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() 
	{
		this.setSize(473, 216);
		this.setContentPane(getJContentPane());
		this.setModal(true);
		this.setResizable(false);
		this.setTitle("Load Predefined Values");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.setBackground(new Color(238, 238, 238));
			jContentPane.add(getJbtnOk(), null);
			jContentPane.add(getJbtnCancel(), null);
			jContentPane.add(getJPanel(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jcboCompound	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJcboCompound() 
	{
		if (jcboInstrument == null) 
		{
			jcboInstrument = new JComboBox(new String[]{"Primary Instrument: Thermo Fisher Scientific Inc. Accela UHPLC Pump","Secondary Instrument: Waters Corporation Acquity UPLC pump"});
			jcboInstrument.setFont(new Font("Dialog", Font.PLAIN, 12));
			jcboInstrument.setBackground(Color.white);
			jcboInstrument.setBounds(new Rectangle(12, 40, 421, 21));
		}
		
		return jcboInstrument;
	}

	/**
	 * This method initializes jbtnOk	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbtnOk() {
		if (jbtnOk == null) {
			jbtnOk = new JButton();
			jbtnOk.setBounds(new Rectangle(196, 148, 125, 31));
			jbtnOk.setActionCommand("OK");
			jbtnOk.setText("OK");
		}
		return jbtnOk;
	}

	/**
	 * This method initializes jbtnCancel	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbtnCancel() {
		if (jbtnCancel == null) {
			jbtnCancel = new JButton();
			jbtnCancel.setBounds(new Rectangle(332, 148, 124, 31));
			jbtnCancel.setText("Cancel");
		}
		return jbtnCancel;
	}

	//@Override
	public void actionPerformed(ActionEvent arg0) 
	{
		if (arg0.getActionCommand() == "OK")
		{
			m_bOk = true;
			this.m_iInstrument = this.jcboInstrument.getSelectedIndex();
			this.m_iCondition = this.jcboGradientFlowRate.getSelectedIndex();
			this.setVisible(false);
			this.dispose(); 
		}
		else if (arg0.getActionCommand() == "Cancel")
		{
			this.setVisible(false);
			this.dispose(); 			
		}
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jLabel1 = new JLabel();
			jLabel1.setBounds(new Rectangle(12, 72, 172, 16));
			jLabel1.setText("Gradient and flow rate:");
			jLabel = new JLabel();
			jLabel.setBounds(new Rectangle(12, 20, 150, 16));
			jLabel.setText("HPLC Instrument:");
			jPanel = new JPanel();
			jPanel.setLayout(null);
			jPanel.setBackground(new Color(238, 238, 238));
			jPanel.setBorder(BorderFactory.createTitledBorder(null, "System conditions:", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jPanel.setBounds(new Rectangle(12, 12, 445, 125));
			jPanel.add(getJcboCompound(), null);
			jPanel.add(jLabel, null);
			jPanel.add(jLabel1, null);
			jPanel.add(getJcboGradientFlowRate(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jcboGradientFlowRate	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJcboGradientFlowRate() {
		if (jcboGradientFlowRate == null) {
			jcboGradientFlowRate = new JComboBox(
					new String[] {
							"10% B to 100% B in 5 min at 200 \u00B5L/min",
							"10% B to 100% B in 20 min at 100 \u00B5L/min",
							"10% B to 100% B in 20 min at 200 \u00B5L/min",
							"10% B to 100% B in 20 min at 400 \u00B5L/min",
							"10% B to 100% B in 80 min at 200 \u00B5L/min"});
			jcboGradientFlowRate.setBounds(new Rectangle(12, 92, 421, 21));
			jcboGradientFlowRate.setFont(new Font("Dialog", Font.PLAIN, 12));
			jcboGradientFlowRate.setBackground(Color.white);
		}
		return jcboGradientFlowRate;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
